package com.bxm.egg.user.facade.bo;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 用户对象封装类
 *
 * @author liujia
 */
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "临时用户信息")
@Data
public class UserInfoBO extends BaseBean {

    private static final long serialVersionUID = -3022637220225110455L;

    @ApiModelProperty("用户ID")
    private Long userId;

    @ApiModelProperty("用户昵称")
    private String nickname;

    @ApiModelProperty("用户头像地址")
    private String headImg;

    @ApiModelProperty("用户状态 0-游客 1-可使用")
    private Integer state = 1;

    @ApiModelProperty("性别:0:未知; 1:男; 2:女")
    private Integer sex;

    @ApiModelProperty(value = "当前地区编码")
    private String locationCode;

    @ApiModelProperty(value = "当前地区名称")
    private String locationName;

    @ApiModelProperty("用户类型")
    private Integer type;
}
