package com.bxm.egg.user.facade.service;

import com.bxm.egg.user.facade.bo.UserInfoBO;
import com.bxm.egg.user.facade.bo.UserStatisticsBO;

import java.util.List;

/**
 * 用户信息内部接口
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/27 7:59 下午
 */
public interface UserInfoFacadeService {

    /**
     * 查询用户信息通过缓存
     *
     * @param userId 用户id
     * @return 用户信息
     */
    UserInfoBO selectUserFromCache(Long userId);

    /**
     * 批量获取用户列表通过缓存
     *
     * @param userIdList 用户id列表
     * @return 用户信息
     */
    List<UserInfoBO> selectUserListFromCache(List<Long> userIdList);

    /**
     * 获取用户的统计信息
     *
     * @param userId 用户id
     * @return 用户统计信息
     */
    UserStatisticsBO getUserStatisticsInfo(Long userId);

    /**
     * 获取用户的资料完成度
     *
     * @param userId 用户id
     * @return 用户的资料完成度
     */
    Long getInfoCompleteState(Long userId);
}