package com.bxm.egg.user.facade.mock;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.user.dto.UserWarmValueUpDTO;
import com.bxm.egg.user.facade.service.UserWarmFacadeService;
import com.bxm.egg.user.param.UserWarmActionParam;
import lombok.extern.slf4j.Slf4j;

/**
 * 温暖值内部接口兜底
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/28 5:26 下午
 */
@Slf4j
public class UserWarmFacadeServiceMock implements UserWarmFacadeService {
    @Override
    public Boolean updateWarm(UserWarmActionParam param) {
        log.error("更新温暖值失败，入参信息: {}", JSON.toJSONString(param));
        return false;
    }

    @Override
    public UserWarmValueUpDTO getUserLevelPopData(Long userId) {
        log.error("获取温暖值弹窗失败，用户id: {}", JSON.toJSONString(userId));

        UserWarmValueUpDTO userWarmValueUpDTO = new UserWarmValueUpDTO();
        return userWarmValueUpDTO;
    }
}