package com.bxm.egg.user.facade.dto;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

import java.util.List;

@ApiModel(description = "用户鉴权相关信息")
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
public class UserAuthCodeDTO extends BaseBean {

    private static final long serialVersionUID = 140277833745066567L;

    @Tolerate
    public UserAuthCodeDTO() {
    }

    @ApiModelProperty(value = "用户持有的权限编码数组")
    private Long[] combineAuthCode;

    @ApiModelProperty(value = "用户持有的权限数据资源列表")
    private List<UserAuthResourceDTO> authResources;
}
