package com.bxm.egg.user.facade.service;

import com.bxm.egg.user.facade.bo.UserInfoBO;
import com.bxm.egg.user.facade.bo.UserStatisticsBO;

import java.util.List;
import java.util.Map;

/**
 * 用户信息内部接口
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/27 7:59 下午
 */
public interface UserInfoFacadeService {

    /**
     * 查询用户信息通过缓存
     *
     * @param userId 用户id
     * @return 用户信息
     */
    UserInfoBO selectUserFromCache(Long userId);

    /**
     * 批量获取用户列表通过缓存
     *
     * @param userIdList 用户id列表
     * @return 用户信息
     */
    List<UserInfoBO> selectUserListFromCache(List<Long> userIdList);

    /**
     * 批量获取用户id->用户信息映射
     *
     * @param userIdList 用户id列表
     * @return 用户信息
     */
    Map<Long, UserInfoBO> selectUserMapFromCache(List<Long> userIdList);

    /**
     * 获取用户的统计信息
     *
     * @param userId 用户id
     * @return 用户统计信息
     */
    UserStatisticsBO getUserStatisticsInfo(Long userId);

    /**
     * 获取用户的资料完成度
     *
     * @param userId 用户id
     * @return 用户的资料完成度
     */
    Long getInfoCompleteState(Long userId);

    /**
     * 是否是平台新注册的用户，不是迁移过来的用户
     *
     * @param userId 用户id
     * @return 用户是否是迁移过来的用户
     */
    Boolean isNewPlatformUser(Long userId);

    /**
     * 获取用户手机号码通过用户id
     *
     * @param userId 用户id
     * @return 手机号码
     */
    String getUserPhone(Long userId);
}