package com.bxm.egg.user.facade.mock;

import com.bxm.egg.common.enums.UserStatusEnum;
import com.bxm.egg.user.facade.bo.UserInfoBO;
import com.bxm.egg.user.facade.bo.UserStatisticsBO;
import com.bxm.egg.user.facade.service.UserInfoFacadeService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 用户
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/28 3:30 下午
 */
@Slf4j
public class UserInfoFacadeServiceMock implements UserInfoFacadeService {
    @Override
    public UserInfoBO selectUserFromCache(Long userId) {
        log.error("查询用户缓存信息失败, 用户id：{}", userId);

        return buildInvalidUserCacheInfo(userId);
    }

    @Override
    public List<UserInfoBO> selectUserListFromCache(List<Long> userIdList) {
        log.error("批量查询用户List缓存信息失败, 用户id：{}", userIdList);
        if (CollectionUtils.isEmpty(userIdList)) {
            return Collections.EMPTY_LIST;
        }
        return userIdList.stream().map(this::buildInvalidUserCacheInfo).collect(Collectors.toList());
    }

    @Override
    public Map<Long, UserInfoBO> selectUserMapFromCache(List<Long> userIdList) {
        log.error("批量查询用户Map缓存信息失败, 用户id：{}", userIdList);
        if (CollectionUtils.isEmpty(userIdList)) {
            return Collections.EMPTY_MAP;
        }

        Map<Long, UserInfoBO> userInfoBOMap = new HashMap<>();

        for (Long userId : userIdList) {
            userInfoBOMap.put(userId, buildInvalidUserCacheInfo(userId));
        }
        return userInfoBOMap;
    }

    @Override
    public UserStatisticsBO getUserStatisticsInfo(Long userId) {
        log.error("查询用户统计信息失败, 用户id：{}", userId);
        UserStatisticsBO userStatisticsBO = new UserStatisticsBO();
        userStatisticsBO.setPostNum(0);
        userStatisticsBO.setReplyNum(0);
        userStatisticsBO.setAttentionNum(0);
        userStatisticsBO.setFanNum(0);
        userStatisticsBO.setLikeNum(0);

        return userStatisticsBO;
    }

    @Override
    public Long getInfoCompleteState(Long userId) {
        log.error("查询用户资料完成度信息失败, 用户id：{}", userId);

        return 0L;
    }

    @Override
    public Boolean isNewPlatformUser(Long userId) {
        log.error("调用是否是平台新注册的用户失败，用户id：{}", userId);

        return false;
    }

    /**
     * 返回一个默认的用户信息
     *
     * @param userId 用户id
     * @return 返回一个默认的用户信息
     */
    private UserInfoBO buildInvalidUserCacheInfo(Long userId) {
        UserInfoBO userCacheInfoBO = new UserInfoBO();

        userCacheInfoBO.setHeadImg("http://bxm-news.oss-cn-hangzhou.aliyuncs.com/img/defaultHeadImg.png");
        userCacheInfoBO.setUserId(userId);
        userCacheInfoBO.setNickname("未知用户");
        userCacheInfoBO.setState(UserStatusEnum.DISABLE.getCode());

        return userCacheInfoBO;
    }
}