/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.integration;

import com.bxm.egg.mq.common.constant.PushMessageEnum;
import com.bxm.egg.mq.common.constant.TemplateTypeEnum;
import com.bxm.egg.mq.common.model.dto.PushMessage;
import com.bxm.egg.mq.common.model.dto.PushPayloadInfo;
import com.bxm.egg.mq.common.model.dto.PushReceiveScope;
import com.bxm.egg.user.integration.DomainIntegrationService;
import com.bxm.egg.user.integration.MessageFacadeIntegrationService;
import com.bxm.egg.user.model.dto.LocationUserInfoDTO;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PushMsgIntegrationService {
    private static final Logger log = LoggerFactory.getLogger(PushMsgIntegrationService.class);
    @Resource
    private MessageFacadeIntegrationService messageSender;
    @Resource
    private DomainIntegrationService domainIntegrationService;
    @Resource
    private SequenceCreater sequenceCreater;
    public static final String postDetail = "egg://community/postDetail?postId=%s&tp=post";

    public void sendSystemMessage(Long userId, int num, LocationUserInfoDTO location) {
        String url = "egg://mine/userHomePage?userId=" + userId;
        String copyWrite = "\u6700\u8fd1\u6709" + num + "\u4eba\u67e5\u770b\u4e86\u4f60\u7684\u4e3b\u9875\uff0c\u770b\u770b\u90fd\u6709\u8c01\u3002";
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.OPEN_URL);
        info.addExtend("msgId", (Object)SequenceHolder.nextLongId());
        info.addExtend("url", (Object)url);
        info.setProtocol(this.buildProtocol(userId, location));
        PushMessage message = PushMessage.build();
        message.setTitle("\u901a\u77e5");
        message.setContent(copyWrite);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId));
        message.setPayloadInfo(info);
        this.messageSender.sendPushMessage(message);
    }

    private String buildProtocol(Long userId, LocationUserInfoDTO location) {
        if (null == location) {
            return null;
        }
        String visitorHtml = StringUtils.join((Object[])new Serializable[]{this.domainIntegrationService.getInnerH5BaseUrl(), "index.html#/visitor?userId=", userId, "&areaCode=", location.getLocationCode(), "&areaName=", location.getLocationName()});
        log.debug("\u6700\u8fd1\u8bbf\u95ee\u4eba\u6570\u8df3\u8f6c\u8bbf\u95ee\u5730\u5740\uff1a[{}]", (Object)visitorHtml);
        return visitorHtml;
    }

    public void pushUserInvite(Long userId, Integer inviteNum, LocationUserInfoDTO location) {
        if (null == location) {
            return;
        }
        String protocol = this.domainIntegrationService.getInnerH5BaseUrl() + "/tk/member.html#/app/apprentice/my?userId=" + userId + "&areaCode=" + location.getLocationCode() + "&areaName=" + location.getLocationName();
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.OPEN_URL);
        info.setProtocol(protocol);
        PushMessage message = PushMessage.build();
        message.setTitle("\u6536\u5f92\u60c5\u51b5\u901a\u77e5");
        message.setContent("\u4f60\u6628\u5929\u6536\u4e86" + inviteNum + "\u4f4d\u5f92\u5f1f\uff0c\u5feb\u53bb\u770b\u770b\u90fd\u662f\u8c01\u5427");
        message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId));
        message.setPayloadInfo(info);
        this.messageSender.sendPushMessage(message);
    }

    public void pushBlockMsg(String actions, Date endTime, Long userId, Long targetPostId) {
        String content = "\u7ecf\u4e3e\u62a5\u548c\u5ba1\u6838\uff0c\u4f60\u5df2\u8fdd\u53cd\u672c\u5730\u4e07\u4e8b\u901a\u7ba1\u7406\u89c4\u8303\uff0c\u88ab" + actions + "\uff0c" + ((DateFormat)DateUtils.DATE_TIME_FORMAT_THREAD_LOCAL.get()).format(endTime) + "\u540e\u53ef\u6062\u590d\u6b63\u5e38\u72b6\u6001";
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.JUMP_TYPE);
        Long msgId = this.sequenceCreater.nextLongId();
        info.setMsgId(msgId);
        info.setProtocol(String.format(postDetail, targetPostId));
        info.addExtend("msgId", (Object)msgId);
        PushMessage message = PushMessage.build();
        message.setTitle("\u8fdd\u89c4\u5904\u7406\u901a\u77e5");
        message.setContent(content);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId));
        message.setPayloadInfo(info);
        this.messageSender.sendPushMessage(message);
    }
}

