/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.integration;

import com.bxm.component.httpclient.utils.OkHttpUtils;
import com.bxm.egg.common.url.ProtocolFactory;
import com.bxm.egg.message.facade.service.MessageFacadeService;
import com.bxm.egg.mq.common.model.dto.PushMessage;
import com.bxm.egg.user.dto.EggResponseModel;
import com.bxm.egg.user.dto.EggSixBindResponse;
import com.bxm.egg.user.facade.bo.UserInfoBO;
import com.bxm.egg.user.facade.service.UserInfoFacadeService;
import com.bxm.egg.user.param.EggSixEnjoyBindParam;
import com.bxm.egg.user.properties.SixEnjoyUrlProperties;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class EggSixEnjoyIntegrationService {
    private static final Logger log = LoggerFactory.getLogger(EggSixEnjoyIntegrationService.class);
    private SixEnjoyUrlProperties sixEnjoyUrlProperties;
    private MessageFacadeService messageFacadeService;
    private static final TypeReference<EggResponseModel<EggSixBindResponse>> EGG_TYPE_REFERENCE = new TypeReference<EggResponseModel<EggSixBindResponse>>(){};
    private static final Integer SUCCESS_CODE = 1;

    private UserInfoFacadeService getUserInfoFacadeService() {
        return (UserInfoFacadeService)SpringContextHolder.getBean(UserInfoFacadeService.class);
    }

    @Async
    public void bind(EggSixEnjoyBindParam param) {
        EggResponseModel<EggSixBindResponse> responseModel = this.request(param);
        if (Objects.equals(SUCCESS_CODE, responseModel.getCode())) {
            EggSixBindResponse data = responseModel.getData();
            if (StringUtils.isNotBlank((CharSequence)data.getFuser_id())) {
                Long inviteUserId = Long.valueOf(data.getFuser_id());
                UserInfoBO userInfoBO = this.getUserInfoFacadeService().selectUserFromCache(inviteUserId);
                PushMessage message = PushMessage.build((String)"\u9080\u8bf7\u597d\u53cb\u7ed1\u5b9a\u5fae\u4fe1\u6210\u529f", (String)("\u60a8\u9080\u8bf7\u7684\u597d\u53cb[" + userInfoBO.getNickname() + "]\uff0c\u6210\u529f\u7ed1\u5b9a\u5fae\u4fe1\uff0c\u5956\u52b1" + this.sixEnjoyUrlProperties.getAwardNum() + "g\u7cae\u98df"));
                message.assign(inviteUserId);
                message.getPayloadInfo().setProtocol(ProtocolFactory.appH5().url(this.sixEnjoyUrlProperties.getInvitePage()).build());
                this.messageFacadeService.sendPushMessage(message);
            }
        } else {
            log.debug("\u8c03\u7528\u86cb\u86cb\u4f73\u63a5\u53e3\u7ed1\u5b9a\u5fae\u4fe1\u5931\u8d25,\u8bf7\u6c42\u6570\u636e\uff1a{},\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)param), (Object)JSON.toJSONString(responseModel));
        }
    }

    private EggResponseModel<EggSixBindResponse> request(EggSixEnjoyBindParam param) {
        String response = OkHttpUtils.postJsonBody((String)this.sixEnjoyUrlProperties.getWxBindAwardUrl(), (String)JSON.toJSONString((Object)param), null);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u86cb\u86cb\u4f73,\u8bf7\u6c42\u6570\u636e\uff1a{},\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)param), (Object)response);
        }
        return (EggResponseModel)JSON.parseObject((String)response, EGG_TYPE_REFERENCE);
    }

    public EggSixEnjoyIntegrationService(SixEnjoyUrlProperties sixEnjoyUrlProperties, MessageFacadeService messageFacadeService) {
        this.sixEnjoyUrlProperties = sixEnjoyUrlProperties;
        this.messageFacadeService = messageFacadeService;
    }
}

