/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.integration;

import com.bxm.egg.message.facade.service.MessageFacadeService;
import com.bxm.egg.mq.common.constant.MessageTypeEnum;
import com.bxm.egg.mq.common.constant.PushMessageEnum;
import com.bxm.egg.mq.common.model.dto.PushMessage;
import com.bxm.egg.mq.common.param.DingtalkMessage;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MessageFacadeIntegrationService {
    private static final Logger log = LoggerFactory.getLogger(MessageFacadeIntegrationService.class);
    @DubboReference(protocol="dubbo", mock="com.bxm.egg.user.integration.fallback.MessageIntegrationServiceMock", cluster="failover", version="1.0.0", check=false, lazy=true)
    private MessageFacadeService messageFacadeService;

    public void sendPushMessage(PushMessage message) {
        this.messageFacadeService.sendPushMessage(message);
    }

    public Integer getUnReadMessageNum(Long userId, MessageTypeEnum messageType) {
        return this.messageFacadeService.getUnreadMsg(userId, messageType);
    }

    public void addFollowMessage(Long userId) {
        PushMessage pushMessage = PushMessage.build();
        pushMessage.setPersistence(false);
        pushMessage.setTitle("\u65b0\u589e\u7c89\u4e1d");
        pushMessage.setContent("\u7c89\u4e1d+1");
        pushMessage.getPayloadInfo().setType(PushMessageEnum.ADD_FUNS.getType());
        this.addMessage(pushMessage, userId);
    }

    public void sendDingtalk(DingtalkMessage message) {
        this.messageFacadeService.sendDingtalk(message);
    }

    private void addMessage(PushMessage pushMessage, Long userId) {
        pushMessage.assign(userId);
        this.messageFacadeService.sendUserMessage(pushMessage);
    }

    public MessageFacadeService getMessageFacadeService() {
        return this.messageFacadeService;
    }
}

