/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.integration;

import com.bxm.egg.user.dto.ForumPostBriefInfoDto;
import com.bxm.egg.user.dto.TopicFacadeVO;
import com.bxm.egg.user.vo.RecommendUserFacadeVo;
import com.bxm.localnews.news.facade.ForumFacadeService;
import com.bxm.localnews.news.facade.dto.ForumPostBriefInfoDTO;
import com.bxm.localnews.news.facade.dto.RecommendUserDTO;
import com.bxm.localnews.news.facade.dto.TopicFacadeDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
public class NewsIntegrationService {
    private static final Logger log = LogManager.getLogger(NewsIntegrationService.class);
    @DubboReference(protocol="dubbo", mock="com.bxm.egg.user.integration.fallback.ForumFacadeServiceMock", cluster="failover", version="1.0.0", check=false, lazy=true)
    private ForumFacadeService forumFacadeService;

    public ForumPostBriefInfoDto getPostWithoutDetail(Long postId) {
        ForumPostBriefInfoDTO briefInfo = this.forumFacadeService.getBriefInfo(postId);
        ForumPostBriefInfoDto resultInfo = new ForumPostBriefInfoDto();
        BeanUtils.copyProperties((Object)briefInfo, (Object)resultInfo);
        return resultInfo;
    }

    public TopicFacadeVO getTopicById(Long topicId) {
        TopicFacadeDTO topic = this.forumFacadeService.getTopicById(topicId);
        TopicFacadeVO topicFacadeVO = new TopicFacadeVO();
        BeanUtils.copyProperties((Object)topic, (Object)topicFacadeVO);
        return topicFacadeVO;
    }

    public List<RecommendUserFacadeVo> getRecommendUserList(String areaCode, Long userId) {
        try {
            List recommendUserInfo = this.forumFacadeService.getRecommendUserInfo(areaCode, userId);
            return recommendUserInfo.stream().map(this::convertToRecommendUserFacadeVo).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u670d\u52a1\u5f02\u5e38 \uff1a {}", (Object)e.getMessage(), (Object)e);
            return new ArrayList<RecommendUserFacadeVo>();
        }
    }

    private RecommendUserFacadeVo convertToRecommendUserFacadeVo(RecommendUserDTO recommendUserDTO) {
        RecommendUserFacadeVo recommendUserFacadeVo = new RecommendUserFacadeVo();
        BeanUtils.copyProperties((Object)recommendUserDTO, (Object)recommendUserFacadeVo);
        return recommendUserFacadeVo;
    }
}

