/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.integration;

import com.bxm.egg.user.model.dto.ImgDTO;
import com.bxm.localnews.news.facade.ForumFacadeService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserNewsIntegrationService {
    @DubboReference(protocol="dubbo", mock="com.bxm.egg.user.integration.fallback.ForumFacadeServiceMock", cluster="failover", version="1.0.0", check=false, lazy=true)
    private ForumFacadeService forumFacadeService;

    public Map<Long, List<ImgDTO>> batchGetAllUserImg(List<Long> userIdList, Long userId) {
        HashMap<Long, List<ImgDTO>> imgMap = new HashMap<Long, List<ImgDTO>>();
        List userImgDTOList = this.forumFacadeService.batchGetUserImg(userIdList, userId);
        if (!CollectionUtils.isEmpty((Collection)userImgDTOList)) {
            userImgDTOList.forEach(e -> {
                List imgDtoList = e.getImgDtoList();
                imgMap.put(e.getUserId(), this.subImgList(imgDtoList.stream().map(this::convertToImgDTO).collect(Collectors.toList()), 4));
            });
        }
        return imgMap;
    }

    private ImgDTO convertToImgDTO(com.bxm.localnews.news.facade.dto.ImgDTO item) {
        ImgDTO imgDTO = new ImgDTO();
        BeanUtils.copyProperties((Object)item, (Object)imgDTO);
        return imgDTO;
    }

    private List<ImgDTO> subImgList(List<ImgDTO> imgDTOList, int limit) {
        if (imgDTOList.size() >= limit) {
            return imgDTOList.subList(0, limit);
        }
        return imgDTOList;
    }
}

