/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.integration.sync;

import com.bxm.sync.facade.dto.UserAssociateDataDTO;
import com.bxm.sync.facade.dto.UserCouponsStatisticsDTO;
import com.bxm.sync.facade.service.SixEnjoyDataStatisticsService;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SixEnjoyDataStatisticsIntegrationService {
    private static final Logger log = LoggerFactory.getLogger(SixEnjoyDataStatisticsIntegrationService.class);
    @DubboReference(protocol="dubbo", mock="com.bxm.egg.user.integration.fallback.sync.SixEnjoyDataStatisticsServiceMock", cluster="failover", version="1.0.0", check=false, lazy=true)
    private SixEnjoyDataStatisticsService sixEnjoyDataStatisticsService;

    public UserCouponsStatisticsDTO getCouponsStatistics(Long userId) {
        UserCouponsStatisticsDTO couponsStatistics = this.sixEnjoyDataStatisticsService.getCouponsStatistics(userId);
        if (couponsStatistics == null) {
            return UserCouponsStatisticsDTO.builder().eggCoupon(Integer.valueOf(0)).cardCoupon(Integer.valueOf(0)).build();
        }
        return couponsStatistics;
    }

    public UserAssociateDataDTO getUserAssociateData(Long userId, Boolean isCompany) {
        UserAssociateDataDTO userAssociateData = this.sixEnjoyDataStatisticsService.getUserAssociateData(userId, isCompany);
        if (userAssociateData == null) {
            return this.buildDefaultInvalidAssociateData();
        }
        return userAssociateData;
    }

    private UserAssociateDataDTO buildDefaultInvalidAssociateData() {
        return UserAssociateDataDTO.builder().orderNumByWeek(Integer.valueOf(0)).orderNumByMonth(Integer.valueOf(0)).orderNumByDay(Integer.valueOf(0)).equipmentNum(Integer.valueOf(0)).associateNum(Integer.valueOf(0)).build();
    }
}

