package com.bxm.egg.user.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

@Builder
@ApiModel("本地人动态信息")
@Data
public class DynamicDTO {

    @ApiModelProperty("动态类型 post:帖子 note:小纸条 guide:资料引导")
    private String type;

    @ApiModelProperty("动态-小纸条内容")
    private NoteDTO note;

    @ApiModelProperty("动态-帖子内容")
    private PostDTO post;

    @ApiModelProperty("动态-资料引导")
    private GuideDTO guide;

    public static DynamicDTO buildEmptyDynamic() {
        return DynamicDTO.builder().type("post").build();
    }

    public static DynamicDTO buildNoteDynamic(NoteDTO note) {
        return DynamicDTO.builder().type("note").note(note).build();
    }

    public static DynamicDTO buildPostDynamic(PostDTO post) {
        return DynamicDTO.builder().type("post").post(post).build();
    }

    public static DynamicDTO buildGuideDynamic(GuideDTO guide) {
        return DynamicDTO.builder().type("guide").guide(guide).build();
    }
}
