package com.bxm.egg.user.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author Gonzo
 * @date  2020-08-22 16:35
 */
@ApiModel(description = "用户注册的信息")
@Data
public class UserRegisterInfoDTO {

    @ApiModelProperty("id")
    private Long userId;

    @ApiModelProperty("用户昵称")
    private String nickname;

    @ApiModelProperty("用户头像地址")
    private String headImg;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("注册时间")
    private Date registerTime;

    @ApiModelProperty("第一次登录app时间 从登录历史获取")
    private Date firstLoginTime;

    @ApiModelProperty("已进入App天数 从登录历史获取")
    private Integer intoAppDays;
}
