package com.bxm.egg.user.model.dto.warmlevel;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.util.List;

/**
 * @author lowi
 * @date 2021/2/25 16:49
 */
@ApiModel("等级对应的权益")
@Data
@Builder
public class LevelEquityDTO {

    @Tolerate
    public LevelEquityDTO() {
    }

    @ApiModelProperty("最低等级展示")
    private Integer minLevel;

    @ApiModelProperty("权益类型")
    private String type;

    @ApiModelProperty("权益标题")
    private String title;

    @ApiModelProperty("权益描述")
    private String content;

    @ApiModelProperty("权益解锁图片")
    private String unlockImg;

    @ApiModelProperty("权益加锁图片")
    private String lockImg;

    @ApiModelProperty("权益图片")
    private String equityImg;
}
