package com.bxm.egg.user.model.dto.warmlevel;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.util.Date;

/**
 * @author lowi
 * @date 2021/2/25 15:19
 */
@ApiModel("用户温暖值获取明细")
@Data
@Builder
public class UserWarmValueDetailDTO {

    @Tolerate
    public UserWarmValueDetailDTO() {

    }

    @ApiModelProperty("明细描述")
    private String detailStr;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date createTime;

    @ApiModelProperty("用户ID")
    private Long userId;

    @ApiModelProperty("温暖值")
    private Integer warmValue;

}
