package com.bxm.egg.user.model.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 用户手机绑定历史表
 * </p>
 *
 * @author liujia
 * @since 2021-09-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("t_user_bind_phone_history")
@ApiModel(value = "UserBindPhoneHistoryEntity对象", description = "用户手机绑定历史表")
public class UserBindPhoneHistoryEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "用户ID")
    private Long userId;

    @ApiModelProperty(value = "手机号码")
    private String bindPhone;

    @ApiModelProperty(value = "当前IP")
    private String currentIp;

    @ApiModelProperty(value = "使用平台")
    private Integer platform;

    private LocalDateTime createTime;


}
