package com.bxm.egg.user.model.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 用户表
 * </p>
 *
 * @author liujia
 * @since 2021-09-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("t_user_info")
@ApiModel(value = "UserInfoEntity对象", description = "用户表")
public class UserInfoEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    @ApiModelProperty(value = "昵称")
    private String nickname;

    @ApiModelProperty(value = "用户名")
    private String username;

    @ApiModelProperty(value = "手机号码")
    private String phone;

    @ApiModelProperty(value = "电子邮箱【六享】")
    private String email;

    @ApiModelProperty(value = "头像")
    private String headImg;

    @ApiModelProperty(value = "性别：0:未知; 1:男; 2:女")
    private Integer sex;

    @ApiModelProperty(value = "用户类型，0：测试用户，1：真实用户，2：马甲号")
    private Integer type;

    @ApiModelProperty(value = "用户状态，0：静默用户，1：有效用户，2：待激活用户，8:虚拟用户，9：黑户")
    private Integer state;

    @ApiModelProperty(value = "密码【六享】")
    private String password;

    @ApiModelProperty(value = "密码盐【六享】")
    private String salt;

    @ApiModelProperty(value = "黑名单 1=白名单 2=黑名单【六享】")
    private Integer blacklist;

    @ApiModelProperty(value = "微信账号")
    private String weixin;

    @ApiModelProperty(value = "当前使用的设备ID")
    private Long equipmentId;

    @ApiModelProperty(value = "是否是蛋蛋佳迁移过来的用户，0不是，1是")
    private Integer eggUser;

    @ApiModelProperty(value = "是否已经已经迁移，0未迁移，1已迁移")
    private Integer migration;

    @ApiModelProperty(value = "1删除，0未删除")
    private Integer deleted;

    @ApiModelProperty(value = "最后一次登录时间")
    private Date lastLoginTime;

    @ApiModelProperty(value = "激活时间")
    private Date activeTime;

    private Date createTime;

    private Date modifyTime;
}
