package com.bxm.egg.user.model.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 用户统计信息表
 * </p>
 *
 * @author liujia
 * @since 2021-09-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("t_user_statistics")
@ApiModel(value = "UserStatisticsEntity对象", description = "用户统计信息表")
public class UserStatisticsEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    @ApiModelProperty(value = "user_id")
    private Long userId;

    @ApiModelProperty(value = "发帖数")
    private Integer postNum;

    @ApiModelProperty(value = "评论数")
    private Integer replyNum;

    @ApiModelProperty(value = "关注数")
    private Integer attentionNum;

    @ApiModelProperty(value = "粉丝数")
    private Integer fanNum;

    @ApiModelProperty(value = "点赞数")
    private Integer likeNum;

    @ApiModelProperty(value = "连续登录天数【六享】")
    private Integer signNum;

    @ApiModelProperty(value = "最大连续登录天数【最大登录天数】")
    private Integer maxSignNum;

    @ApiModelProperty(value = "温暖值(等级相关)")
    private Integer warmValue;

    private LocalDateTime createTime;

    private LocalDateTime modifyTime;


}
