package com.bxm.egg.user.model.entity.medal;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * t_user_medal_relation_info
 *
 * @author
 */
@Data
public class UserMedalRelationInfoEntity implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 勋章的父id
     */
    private Long medalParentId;

    /**
     * 勋章的id
     */
    private Long medalId;

    /**
     * 勋章类别
     */
    private Integer medalCategory;

    /**
     * 勋章等级
     */
    private Integer medalLevel;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 是否佩戴：0:未佩戴，1已佩戴
     */
    private Integer hasWear;

    /**
     * 佩戴勋章的顺序
     */
    private Integer wearOrder;

    /**
     * 删除原因
     */
    private String deletedReason;

    /**
     * 是否被删除, 0：未被删除，1：被删除
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 变更时间
     */
    private Date modifyTime;

    private static final long serialVersionUID = 1L;
}