package com.bxm.egg.user.model.param.login;

import com.bxm.newidea.component.param.BasicParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 * 基础登录参数
 * 重写了hashcode，用于后续判断是否重复请求，子类需要调用父类的hashcode方法
 *
 * @author wzy
 * @date 2021年09月14日14:20:33
 **/
@Data
public class LoginParam extends BasicParam {

    private static final long serialVersionUID = -7408985289873115179L;
    @ApiModelProperty(hidden = true, value = "请求IP")
    private String requestIp;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LoginParam that = (LoginParam) o;
        return this.hashCode() == that.hashCode();
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this,
                new String[]{"requestIp", "cliTime"});
    }
}
