package com.bxm.egg.user.model.param.login;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 用户名密码APP登录入参
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/9 1:53 下午
 */
@Data
@ApiModel(description = "用户名密码APP登录信息")
public class UserAccountAppLoginParam extends LoginParam {

    private static final long serialVersionUID = 4672093758014443494L;
    @ApiModelProperty("用户名")
    @NotBlank(message = "用户名不能为空")
    private String userName;

    @ApiModelProperty("密码")
    @NotBlank(message = "密码不能为空")
    private String password;
}