package com.bxm.egg.user.model.vo.medal;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/2/24 3:03 下午
 */
@Data
@ApiModel("勋章等级相关信息")
public class MedalLevelVO {

    @ApiModelProperty("勋章的父id")
    private Long medalParentId;

    @ApiModelProperty("勋章id")
    private Long medalId;

    @ApiModelProperty("勋章的名称")
    private String medalName;

    @ApiModelProperty("勋章的等级")
    private Integer level;

    @ApiModelProperty("解锁描述:如连续签到30天即可解锁")
    private String unlockDesc;

    @ApiModelProperty("勋章成就描述：如xx达成连续签到30天！有这份持久力的，都不是一般人")
    private String explainText;

    @ApiModelProperty("升级描述：如连续签到500天可升级")
    private String upLevelDesc;

    @ApiModelProperty("展示gif图标地址")
    private String displayIconUrl;

    @ApiModelProperty("展示静态图标地址地址")
    private String displayStaticIconUrl;

    @ApiModelProperty("展示未解锁图标地址")
    private String displayLockIconUrl;

    @ApiModelProperty("是否解锁")
    private Boolean unlock;

    @ApiModelProperty("升级或解锁的跳转地址")
    private String jumpUrl;

    @ApiModelProperty("授予时间")
    @JsonFormat(pattern = DateUtils.DATE_FORMAT)
    private Date grantDateTime;
}