package com.bxm.egg.user.model.bo;

import com.bxm.egg.user.model.UserEquityDTO;
import com.bxm.egg.user.model.WearMedalDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 用户缓存信息
 *
 * @author wzy
 * @date 2021年09月14日19:16:42
 **/
@Data
public class UserCacheInfoBO {

    /**
     * 如果缓存对象中存储的值发生了变化，则更新此值
     */
    public static final Integer CACHE_VERSION = 1;

    private Integer v = CACHE_VERSION;

    /**
     * 用户ID
     */
    private Long userId;

    @ApiModelProperty(value = "昵称")
    private String nickname;

    @ApiModelProperty(value = "电子邮箱【六享】")
    private String email;

    @ApiModelProperty(value = "头像")
    private String headImg;

    @ApiModelProperty(value = "性别：0:未知; 1:男; 2:女")
    private Integer sex;

    @ApiModelProperty(value = "用户类型，0：测试用户，1：真实用户，2：马甲号")
    private Integer type;

    @ApiModelProperty(value = "黑名单 1=白名单 2=黑名单【六享】")
    private Integer blacklist;

    @ApiModelProperty(value = "微信账号")
    private String weixin;

    @ApiModelProperty(value = "当前使用的设备ID")
    private Long equipmentId;

    /**
     * 用户账号创建时间
     */
    private Date createTime;

    /**
     * 最后一次登录时间
     */
    private Date lastLoginTime;

    @ApiModelProperty(value = "激活时间")
    private Date activeTime;

    /**
     * 用户状态
     * 0：静默
     * 1： 正常
     * 2：待激活
     * 7：测试用户
     * 8：虚拟用户
     * 9：已屏蔽用户
     */
    private Integer state;

    @ApiModelProperty("用户资料信息")
    private UserInformationBO userInformationBO;

    @ApiModelProperty("用户定位区域信息")
    private UserLocationBO userLocationBO;

    @ApiModelProperty("3.12.0 用户温暖值等级信息")
    private UserEquityDTO userWarmLevelDTO;

    @ApiModelProperty("3.12.0 佩戴勋章列表")
    private List<WearMedalDTO> wearMedalList;
}
