package com.bxm.egg.user.model.dto;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author zhaoyadong 2019/3/4 23:35
 * @desc
 */
@ApiModel(description = "用户账户信息和按天数现金统计")
public class UserAccountDayCashDTO {

    @ApiModelProperty("用户账户信息")
    private UserAccountDTO userAccount;

    @ApiModelProperty("对应天数现金统计")
    private List<UserDayCashDTO> dayCashDTOList;

    @ApiModelProperty("提现对应信息（如果不存在对应的提现信息则返回null）")
    private UserWithdrawDTO userWithdrawDTO;

    public UserAccountDayCashDTO() {
    }

    public UserAccountDayCashDTO(UserAccountDTO userAccount, List<UserDayCashDTO> dayCashDTOList,
                                 UserWithdrawDTO userWithdrawDTO) {
        this.userAccount = userAccount;
        this.dayCashDTOList = dayCashDTOList;
        this.userWithdrawDTO = userWithdrawDTO;
    }

    public UserAccountDTO getUserAccount() {
        return userAccount;
    }

    public void setUserAccount(UserAccountDTO userAccount) {
        this.userAccount = userAccount;
    }

    public List<UserDayCashDTO> getDayCashDTOList() {
        return dayCashDTOList;
    }

    public void setDayCashDTOList(List<UserDayCashDTO> dayCashDTOList) {
        this.dayCashDTOList = dayCashDTOList;
    }

    public UserWithdrawDTO getUserWithdrawDTO() {
        return userWithdrawDTO;
    }

    public void setUserWithdrawDTO(UserWithdrawDTO userWithdrawDTO) {
        this.userWithdrawDTO = userWithdrawDTO;
    }
}
