package com.bxm.egg.user.model.dto;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel("最近访客记录")
public class UserVisitDTO {

    @ApiModelProperty("访问日期")
    @JsonFormat(pattern=DateUtils.DATE_FORMAT_MONTH_DAY_FORMAT)
    private LocalDate visitDate;

    @ApiModelProperty("访客用户信息")
    private List<VisitUserInfo> visitUserInfoList;

    @ApiModel("访客用户信息")
    @Data
    public static class VisitUserInfo{
        @ApiModelProperty("用户id")
        private Long visitUserId;

        @ApiModelProperty("昵称")
        private String visitUserNickname;

        @ApiModelProperty("头像")
        private String visitUserHeadImg;

        @ApiModelProperty("是否是vip：0-不是 1-是")
        private Integer isVip;

        @ApiModelProperty("用户性别：0:未知; 1:男; 2:女")
        private Byte visitUserSex;

        @ApiModelProperty("访问日期")
        @JsonFormat(pattern=DateUtils.DATE_FORMAT_MONTH_DAY_FORMAT)
        private LocalDate visitDate;

        @ApiModelProperty("访问时间")
        @JsonFormat(pattern="HH:mm")
        private LocalDateTime visitTime;
    }



}
