package com.bxm.egg.user.model.dto.block;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @author
 */
@Data
@ApiModel("限制用户请求参数")
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class UserBlockDTO implements Serializable {

    private static final long serialVersionUID = 5180563913526686438L;
    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id", required = true)
    private Long userId;

    @ApiModelProperty(value = "禁止私聊,true-禁止,false-不禁止")
    private Boolean chatLimitFlag;

    @ApiModelProperty(value = "拉黑,true-拉黑,false-不拉黑")
    private Boolean blockFlag;

    @ApiModelProperty(value = "true 禁止评论,false不禁止")
    private Boolean forbidComment;

    @ApiModelProperty(value = "true 禁止发帖,false不禁止")
    private Boolean forbidPost;

    @ApiModelProperty(value = "限制时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date blockTime;
}