package com.bxm.egg.user.model.dto.login;

import com.bxm.egg.user.model.UserEquityDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

/**
 * 用户登录结果信息
 *
 * @author wzy
 * @date 2021年09月09日11:36:05
 **/
@Data
@ApiModel(description = "用户登录结果信息")
@Builder
public class LoginResultDTO {

    @Tolerate
    public LoginResultDTO() {
    }

    @ApiModelProperty("登录后的用户ID")
    private Long userId;

    @ApiModelProperty("true表示用户是首次登录")
    private Boolean firstLogin;

    @ApiModelProperty("用户昵称")
    private String nickName;

    @ApiModelProperty("用户头像")
    private String headImg;

    @ApiModelProperty("访问token")
    private String accessToken;

    @ApiModelProperty("手机号码")
    private String phone;

    @ApiModelProperty("刷新token")
    private String refreshToken;

    @ApiModelProperty("3.12.0用户权益等级信息")
    private UserEquityDTO equityDTO;

    @ApiModelProperty("用户的位置信息")
    private UserLocationLoginDTO userLocationLoginDTO;
}
