package com.bxm.egg.user.model.dto.warmlevel;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author lowi
 * @date 2021/2/25 15:07
 */
@ApiModel("用户等级列表")
@Data
@Builder
public class UserLevelListDTO {

    @ApiModelProperty("等级")
    private Integer level;

    @ApiModelProperty("权益数")
    private Integer equityNum;

    @ApiModelProperty("当前温暖值")
    private Integer currWarmValue;

    @ApiModelProperty("下级温暖值")
    private Integer nextWarmValue;

    @ApiModelProperty("等级状态 0 当前等级 1 已达成 2 待升级")
    private Integer levelStatus;

    @ApiModelProperty("下一级别")
    private Integer nextLevel;

    @ApiModelProperty("达成时间")
    @JsonFormat(pattern = DateUtils.DATE_FORMAT)
    private Date finishDate;

    @Tolerate
    public UserLevelListDTO() {

    }
}
