package com.bxm.egg.user.model.vo;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * t_user_visit
 *
 * @author
 */
public class UserVisit implements Serializable {
    /**
     * 被访问者用户id
     */
    private Long userId;

    /**
     * 昵称
     */
    private String userNickname;

    /**
     * 头像
     */
    private String userHeadImg;

    /**
     * 性别 1：男 2：女 0：未知
     */
    private Integer userSex;

    /**
     * 访问者用户id
     */
    private Long visitUserId;

    /**
     * 访问者用户昵称
     */
    private String visitUserNickname;

    /**
     * 访问者用户头像
     */
    private String visitUserHeadImg;

    /**
     * 访问者性别
     */
    private Integer visitUserSex;

    /**
     * 访问日期
     */
    private LocalDate visitDate;

    /**
     * 访问时间
     */
    private LocalDateTime visitTime;

    /**
     * 是否是虚假的访客记录  1：是   0：否(真实)
     */
    private Byte isVest;

    private static final long serialVersionUID = 1L;

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUserNickname() {
        return userNickname;
    }

    public void setUserNickname(String userNickname) {
        this.userNickname = userNickname;
    }

    public String getUserHeadImg() {
        return userHeadImg;
    }

    public void setUserHeadImg(String userHeadImg) {
        this.userHeadImg = userHeadImg;
    }

    public Integer getUserSex() {
        return userSex;
    }

    public void setUserSex(Integer userSex) {
        this.userSex = userSex;
    }

    public Long getVisitUserId() {
        return visitUserId;
    }

    public void setVisitUserId(Long visitUserId) {
        this.visitUserId = visitUserId;
    }

    public String getVisitUserNickname() {
        return visitUserNickname;
    }

    public void setVisitUserNickname(String visitUserNickname) {
        this.visitUserNickname = visitUserNickname;
    }

    public String getVisitUserHeadImg() {
        return visitUserHeadImg;
    }

    public void setVisitUserHeadImg(String visitUserHeadImg) {
        this.visitUserHeadImg = visitUserHeadImg;
    }

    public Integer getVisitUserSex() {
        return visitUserSex;
    }

    public void setVisitUserSex(Integer visitUserSex) {
        this.visitUserSex = visitUserSex;
    }

    public LocalDate getVisitDate() {
        return visitDate;
    }

    public void setVisitDate(LocalDate visitDate) {
        this.visitDate = visitDate;
    }

    public LocalDateTime getVisitTime() {
        return visitTime;
    }

    public void setVisitTime(LocalDateTime visitTime) {
        this.visitTime = visitTime;
    }

    public Byte getIsVest() {
        return isVest;
    }

    public void setIsVest(Byte isVest) {
        this.isVest = isVest;
    }
}