package com.bxm.egg.user.model.vo.medal;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/2/24 2:50 下午
 */
@Data
@ApiModel("成就勋章详情VO")
public class AchievementMedalDetailVO {
    @ApiModelProperty("勋章的父id")
    private Long medalParentId;

    @ApiModelProperty("用户昵称")
    private String nickname;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("头像url")
    private String headImg;

    @ApiModelProperty("用户等级")
    private Integer userLevel;

    @ApiModelProperty("用户等级图标")
    private String userLevelImg;

    @ApiModelProperty("当前最高等级：如果是0说明用户从未获得勋章")
    private Integer currentLevel;

    @ApiModelProperty("勋章等级信息，会按照等级从低到高的顺序返回")
    private List<MedalLevelVO> medalLevelList;
}