package com.bxm.egg.user.service.barrels;

import com.bxm.egg.user.service.barrels.alternative.AlternativeEmergencyNativeBarrel;
import com.bxm.egg.user.service.barrels.alternative.AlternativeNearByNativeBarrel;
import com.bxm.egg.user.service.barrels.alternative.AlternativeSameCityNativeBarrel;
import com.bxm.egg.user.service.barrels.weight.*;
import com.google.common.collect.Maps;

import java.util.Map;

public class BarrelOrder {

    private BarrelOrder() {
    }

    private static Map<Class<? extends BarrelChoose>, Integer> BARREL_CHOOSE_MAP = Maps.newHashMap();

    static {
        BARREL_CHOOSE_MAP.put(AlternativeSameCityNativeBarrel.class, 1);
        BARREL_CHOOSE_MAP.put(AlternativeNearByNativeBarrel.class, 2);
        BARREL_CHOOSE_MAP.put(AlternativeEmergencyNativeBarrel.class, 3);

        BARREL_CHOOSE_MAP.put(WeightNearByNativeBarrel.class, 3);
        BARREL_CHOOSE_MAP.put(WeightEmergencyNativeBarrel.class, 5);
        BARREL_CHOOSE_MAP.put(WeightOtherNativeBarrel.class, 4);
        BARREL_CHOOSE_MAP.put(WeightSameCityNativeBarrel.class, 2);
        BARREL_CHOOSE_MAP.put(WeightDataPreloadNativeBarrel.class, 1);


    }

    public static int get(Class<? extends BarrelChoose> clazz) {
        return BARREL_CHOOSE_MAP.get(clazz);
    }
}