package com.bxm.egg.user.vo;


import lombok.Data;

import java.io.Serializable;
import java.util.Objects;

@Data
public class RecommendNative implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 距离
     */
    private Integer distance;

    /**
     * 小纸条id
     */
    private Long lastNoteId;

    /**
     * 推荐类型
     */
    private Byte recommendType;


    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RecommendNative that = (RecommendNative) o;
        return Objects.equals(userId, that.userId);
    }
}