/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.service.barrels.weight;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.enums.RecommendCategoryEnum;
import com.bxm.egg.user.model.dto.UserInfoDTO;
import com.bxm.egg.user.param.NativeRecommendContext;
import com.bxm.egg.user.param.RecommendNativeParam;
import com.bxm.egg.user.param.WeightParam;
import com.bxm.egg.user.properties.RecommendProperties;
import com.bxm.egg.user.service.BlockUserService;
import com.bxm.egg.user.service.barrels.BarrelSupport;
import com.bxm.egg.user.service.barrels.weight.AbstractWeightBarrelChoose;
import com.bxm.egg.user.service.handler.WeightAlternateBarrelHandler;
import com.bxm.egg.user.service.handler.WeightDefaultBarrelHandler;
import com.bxm.egg.user.service.handler.WeightPreferredBarrelHandler;
import com.bxm.egg.user.vo.RecommendNative;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.time.LocalDate;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@BarrelSupport(value={WeightPreferredBarrelHandler.class, WeightDefaultBarrelHandler.class, WeightAlternateBarrelHandler.class})
@Service
public class WeightDataPreloadNativeBarrel
extends AbstractWeightBarrelChoose {
    private static final Logger log = LoggerFactory.getLogger(WeightDataPreloadNativeBarrel.class);
    @Autowired
    private BlockUserService blockUserService;
    @Autowired
    private RedisSetAdapter redisSetAdapter;
    @Autowired
    private RecommendProperties recommendProperties;

    @Override
    public Boolean doInvoke(NativeRecommendContext nativeRecommendContext) {
        if (RecommendCategoryEnum.OTHER.getName().equals(nativeRecommendContext.getRecommendCategory()) && 1 == nativeRecommendContext.getActionType()) {
            return true;
        }
        if (1 == nativeRecommendContext.getActionType()) {
            UserInfoDTO user = (UserInfoDTO)nativeRecommendContext.getParam("user");
            RecommendNativeParam recommendNativeParam = RecommendNativeParam.builder().ownSex(user.getSex() == null ? (byte)0 : user.getSex()).lat(nativeRecommendContext.getLat()).lon(nativeRecommendContext.getLon()).currentAreaCode(nativeRecommendContext.getCurrentAreaCode()).hometownCode(user.getHometownCode() == null ? user.getLocationCode() : user.getHometownCode()).locationCode(user.getLocationCode()).recommendCategory(nativeRecommendContext.getRecommendCategory()).userId(nativeRecommendContext.getUserId()).build();
            log.debug("\u672c\u5730\u4eba\u63a8\u8350->\u901a\u7528\u53c2\u6570:[{}]", JSON.toJSON((Object)recommendNativeParam));
            if (RecommendCategoryEnum.FILTER.getName().equals(nativeRecommendContext.getRecommendCategory())) {
                this.generateFilterParam(nativeRecommendContext, recommendNativeParam);
                log.debug("\u672c\u5730\u4eba\u63a8\u8350->\u7b5b\u9009\u53c2\u6570:[{}]", JSON.toJSON((Object)recommendNativeParam));
            }
            nativeRecommendContext.addParam("recommendNativeParam", recommendNativeParam);
            WeightParam weightParam = (WeightParam)nativeRecommendContext.getParam("weight");
            recommendNativeParam.setWeightParam(weightParam);
            log.debug("\u672c\u5730\u4eba\u63a8\u8350->\u6743\u91cd\u53c2\u6570:[{}]", JSON.toJSON((Object)weightParam));
            CompletableFuture<Void> future1 = CompletableFuture.runAsync(() -> {
                Map<Long, Integer> blockUserMap = this.blockUserService.listBlockUser();
                log.debug("\u672c\u5730\u4eba\u63a8\u8350->\u83b7\u53d6\u62c9\u9ed1\u6216\u8005\u964d\u6743\u7684\u7528\u6237map:[{}]", JSON.toJSON(blockUserMap));
                nativeRecommendContext.addParam("userBlock", blockUserMap);
            });
            CompletableFuture<Void> future2 = CompletableFuture.runAsync(() -> {
                Map<Long, Integer> ignoreUserMap = this.recommendProperties.getIgnoreUserList().parallelStream().collect(Collectors.toMap(Long::longValue, e -> 1, (key1, key2) -> key1));
                log.debug("\u672c\u5730\u4eba\u63a8\u8350->\u83b7\u53d6\u5ffd\u7565\u7684\u7528\u6237map:[{}]", JSON.toJSON(ignoreUserMap));
                nativeRecommendContext.addParam("userIgnore", ignoreUserMap);
            });
            CompletableFuture<Void> future3 = CompletableFuture.runAsync(() -> {
                Multimap<Long, RecommendNative> recommendNativeMap = this.getRecommendCache(nativeRecommendContext);
                log.debug("\u672c\u5730\u4eba\u63a8\u8350->\u83b7\u53d6\u5df2\u7ecf\u66dd\u5149\u8fc7\u7684\u7528\u6237map:[{}]", JSON.toJSON(recommendNativeMap));
                nativeRecommendContext.addParam("userCache", recommendNativeMap);
            });
            CompletableFuture<Void> all = CompletableFuture.allOf(future1, future2, future3);
            try {
                all.get();
                log.info("\u3010\u62c9\u9ed1\u6216\u8005\u964d\u6743\u3011\u3001\u3010\u5ffd\u7565\u3011\u3001\u3010\u66dd\u5149\u3011\u51c6\u5907\u6570\u636e\u5c31\u7eea");
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("\u3010\u62c9\u9ed1\u6216\u8005\u964d\u6743\u3011\u3001\u3010\u5ffd\u7565\u3011\u3001\u3010\u66dd\u5149\u3011\u51c6\u5907\u6570\u636e\u83b7\u53d6\u51fa\u9519[{}]", (Object)e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        return false;
    }

    private void generateFilterParam(NativeRecommendContext nativeRecommendContext, RecommendNativeParam recommendNativeParam) {
        boolean needQuery;
        boolean bl = needQuery = null != nativeRecommendContext.getMaxAge() && null != nativeRecommendContext.getMinAge() && (60 != nativeRecommendContext.getMaxAge() || 18 != nativeRecommendContext.getMinAge());
        if (needQuery) {
            recommendNativeParam.setStartBirth(LocalDate.now().minusYears(nativeRecommendContext.getMaxAge().byteValue()));
            recommendNativeParam.setEndBirth(LocalDate.now().minusYears(nativeRecommendContext.getMinAge().byteValue()));
        }
        if (null != nativeRecommendContext.getSex()) {
            recommendNativeParam.setSex(nativeRecommendContext.getSex());
        }
        if (null != nativeRecommendContext.getIndustryId()) {
            recommendNativeParam.setJobCategory(nativeRecommendContext.getIndustryId());
        }
    }

    private Multimap<Long, RecommendNative> getRecommendCache(NativeRecommendContext nativeRecommendContext) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        KeyGenerator recommendKey = RedisConfig.USER_RECOMMEND.copy().appendKey((Object)"recommended").appendKey((Object)nativeRecommendContext.getRecommendCategory()).appendKey((Object)nativeRecommendContext.getUserId());
        if (Boolean.FALSE.equals(this.redisSetAdapter.hasKey(recommendKey))) {
            return multimap;
        }
        Set recommendNativeList = this.redisSetAdapter.getAllMembers(recommendKey, RecommendNative.class);
        recommendNativeList.forEach(arg_0 -> WeightDataPreloadNativeBarrel.lambda$getRecommendCache$5((Multimap)multimap, arg_0));
        return multimap;
    }

    private static /* synthetic */ void lambda$getRecommendCache$5(Multimap multimap, RecommendNative e) {
        multimap.put((Object)e.getUserId(), (Object)e);
    }
}

