/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.service.handler;

import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.param.NativeRecommendContext;
import com.bxm.egg.user.properties.RecommendProperties;
import com.bxm.egg.user.service.handler.HandlerOrder;
import com.bxm.egg.user.service.intefaces.BarrelHandler;
import com.bxm.egg.user.service.intefaces.WeightSupport;
import com.bxm.egg.user.vo.RecommendNative;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.BaseParam;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractWeightBarrelHandler<T extends BaseParam>
implements BarrelHandler<BaseParam>,
WeightSupport {
    private static final Logger log = LoggerFactory.getLogger(AbstractWeightBarrelHandler.class);
    @Autowired
    protected RecommendProperties recommendProperties;
    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;
    @Autowired
    private RedisSetAdapter redisSetAdapter;

    @Override
    public <R> R handle(BaseParam baseParam) {
        BaseParam param = baseParam;
        R result = this.doHandle(param);
        this.processAfter(param);
        return result;
    }

    protected abstract <R> R doHandle(T var1);

    private void processAfter(T t) {
        NativeRecommendContext param = (NativeRecommendContext)((Object)t);
        List<RecommendNative> recommendNativeList = param.getResult();
        KeyGenerator recommendKey = RedisConfig.USER_RECOMMEND.copy().appendKey((Object)"recommended").appendKey((Object)param.getRecommendCategory()).appendKey((Object)param.getUserId());
        if (!CollectionUtils.isEmpty(recommendNativeList)) {
            this.redisSetAdapter.add(recommendKey, (Object[])recommendNativeList.parallelStream().toArray(Object[]::new));
            this.redisSetAdapter.expire(recommendKey, (long)this.recommendProperties.getCacheInterval().intValue());
        } else {
            this.redisSetAdapter.remove(recommendKey);
        }
    }

    @Override
    public Boolean support(BaseParam baseParam) {
        NativeRecommendContext param = (NativeRecommendContext)baseParam;
        Long userId = param.getUserId();
        String areaCode = param.getCurrentAreaCode();
        return this.getResultFromJs(areaCode, userId);
    }

    private Boolean getResultFromJs(String areaCode, Long userId) {
        String formula = this.recommendProperties.getFormula().getOrDefault(this.supportWeight(), "").toString();
        if (StringUtils.isBlank((CharSequence)formula)) {
            return true;
        }
        ScriptEngineManager sem = new ScriptEngineManager();
        ScriptEngine engine = sem.getEngineByExtension("js");
        engine.put("userId", userId);
        engine.put("areaCode", areaCode);
        Object result = null;
        try {
            result = engine.eval(formula);
        }
        catch (ScriptException e) {
            log.error("js\u811a\u672c\u6267\u884c\u9519\u8bef,\u5185\u5bb9\u4e3a:[{}]", (Object)formula);
        }
        return (Boolean)result;
    }

    public int getOrder() {
        return HandlerOrder.get(this.getClass());
    }
}

