package com.bxm.egg.user.service.barrels.weight;

import com.bxm.egg.user.enums.RecommendCategoryEnum;
import com.bxm.egg.user.param.NativeRecommendContext;
import com.bxm.egg.user.param.RecommendNativeParam;
import com.bxm.egg.user.service.barrels.BarrelSupport;
import com.bxm.egg.user.service.handler.WeightAlternateBarrelHandler;
import com.bxm.egg.user.service.handler.WeightDefaultBarrelHandler;
import com.bxm.egg.user.service.handler.WeightPreferredBarrelHandler;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * 其他推荐
 */
@BarrelSupport(value = {
        WeightPreferredBarrelHandler.class,
        WeightDefaultBarrelHandler.class,
        WeightAlternateBarrelHandler.class})
@Service
public class WeightOtherNativeBarrel extends AbstractWeightBarrelChoose {

    @Override
    protected Boolean doInvoke(NativeRecommendContext nativeRecommendContext) {
        //当筛选没有结果时，需要填充其他推荐
        if (RecommendCategoryEnum.FILTER.getName().equals(nativeRecommendContext.getRecommendCategory())
                && 1 == nativeRecommendContext.getActionType()
                && CollectionUtils.isEmpty(nativeRecommendContext.getResult())) {

            //重新组装一个新的参数实体,删除筛选条件
            this.minusFilterParam(nativeRecommendContext);

            //本地人推荐
            if (preSameCityInvoke(nativeRecommendContext)) {
                boolean flag = doSameCityInvoke(nativeRecommendContext, null);
                if (flag) {
                    return true;
                }
            }

            //附近的人推荐
            if (preNearbyInvoke(nativeRecommendContext)) {
                boolean flag = doNearbyInvoke(nativeRecommendContext);
                if (flag) {
                    return true;
                }
            }
        }
        return true;
    }

    /**
     * 删除筛选条件
     * @param nativeRecommendContext
     */
    private void minusFilterParam(NativeRecommendContext nativeRecommendContext){
        nativeRecommendContext.setRecommendCategory(RecommendCategoryEnum.OTHER.getName());
        nativeRecommendContext.setHasSameCity((byte) 1);

        RecommendNativeParam recommendNativeParam = nativeRecommendContext.getParam(RECOMMEND_NATIVE_PARAM);
        recommendNativeParam.setEndBirth(null);
        recommendNativeParam.setStartBirth(null);
        recommendNativeParam.setSex(null);
        recommendNativeParam.setJobCategory(null);
    }
}
