package com.bxm.egg.user.follow;

import com.bxm.egg.user.enums.UserFollowStatusEnum;
import com.bxm.egg.user.model.param.UserFollowParam;
import com.bxm.egg.user.model.vo.UserFollow;
import com.bxm.newidea.component.dto.IPageModel;

import java.util.List;

/**
 * 用户关注service接口
 *
 * @author wzy
 * @date 2021年09月22日09:48:07
 */
public interface UserFollowService {

    /**
     * 判断是否关注
     *
     * @param currentUserId 当前用户
     * @param targetUserId  目标用户
     * @return 是否关注
     */
    Boolean isFollowed(Long currentUserId, Long targetUserId);

    /**
     * 判断用户是否关注了集合中的用户
     *
     * @param currentUserId 当前用户
     * @param targetUserIds 目标用户集合
     * @return 关注的用户id
     */
    List<Long> isFolloweds(Long currentUserId, List<Long> targetUserIds);

    /**
     * 是否存在关注消息 该消息获取一次后就销毁，主要用于私聊中显示关注通知
     *
     * @param userId       当前用户
     * @param targetUserId 目标用户
     * @return true表示有消息
     */
    Boolean hasFollowMsg(Long userId, Long targetUserId);

    /**
     * 点击关注/取消关注
     *
     * @param userId       用户id
     * @param followUserId 被关注用户
     * @param type         {@link UserFollowStatusEnum}关注类型
     * @return 是否成功
     */
    Boolean follow(Long userId, Long followUserId, Byte type);

    /**
     * 关注列表
     *
     * @param param 入参
     * @return 分页列表
     */
    IPageModel<UserFollow> followList(UserFollowParam param);

    /**
     * 分页查询用户粉丝列表
     *
     * @param param 查询参数
     * @return 分页结果
     */
    IPageModel<UserFollow> queryFunsByPage(UserFollowParam param);

    /**
     * 获取用户关注的用户的id集合
     *
     * @param userId 用户id
     * @return 关注的用户id
     */
    List<Long> followUserIdList(Long userId);


}