package com.bxm.egg.user.info;

import com.bxm.egg.user.model.entity.UserInformationEntity;

import java.util.Date;

/**
 * 用户资料service接口
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/17 10:59 上午
 */
public interface UserInformationService {

    /**
     * 根据用户id获取资料信息
     *
     * @param userId 用户id
     * @return 用户资料信息
     */
    UserInformationEntity getUserInformationByUserId(Long userId);

    /**
     * 更新用户生日
     *
     * @param userId   用户id
     * @param birthday 生日
     * @return 影响行数
     */
    int updateUserBirthday(Long userId, Date birthday);

    /**
     * 更新背景图片通过用户id
     *
     * @param userId           用户id
     * @param backgroundImgUrl 背景图片
     * @return 影响行数
     */
    int updateBackgroundImgUrlByUserId(Long userId,
                                       String backgroundImgUrl);
}