package com.bxm.egg.user.info;

import com.bxm.egg.user.model.bo.UserWechatBindBO;
import com.bxm.egg.user.model.entity.UserGrantWechatAppEntity;
import com.bxm.egg.user.model.param.UserBindWxParam;
import com.bxm.newidea.component.bo.Message;

import java.util.Optional;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/8 5:50 下午
 */
public interface UserWechatGrantService {
    /**
     * 用户UnionId是否存在，存在返回用户id
     *
     * @param unionId unionId
     * @return 用户id
     */
    Optional<UserGrantWechatAppEntity> userInfoUnionIdExist(String unionId);

    /**
     * 更新微信授权信息
     *
     * @param userId  用户id
     * @param unionId unionId
     * @return 影响行数
     */
    int updateWechatGrantBindUserId(Long userId, String unionId);

    /**
     * 判断用户是否已经绑定过微信
     *
     * @param userId 用户id
     * @return 是否已经绑定
     */
    Boolean userHasBindWx(Long userId);

    /**
     * 用户绑定微信
     *
     * @param userBindWxParam 用户绑定微信入参
     * @return 是否绑定成功
     */
    Message userBindWx(UserBindWxParam userBindWxParam);

    /**
     * 创建用户绑定微信记录
     *
     * @param userWechatBindBO 创建用户微信绑定记录
     * @return 是否绑定成功
     */
    Boolean grantBindWxRecord(UserWechatBindBO userWechatBindBO);
}