package com.bxm.egg.user.info.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.egg.user.constant.UserStateEnum;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.integration.sync.HuolaUserRegisterIntegrationService;
import com.bxm.egg.user.mapper.UserGrantWechatAppMapper;
import com.bxm.egg.user.mapper.UserInfoMapper;
import com.bxm.egg.user.model.entity.UserGrantWechatAppEntity;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.param.login.canel.CancelUserParam;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.sync.facade.param.UserRegisterParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/9/14 2:09 下午
 */
@Slf4j
@Service
public class UserInfoServiceImpl implements UserInfoService {
    @Resource
    private UserInfoMapper userInfoMapper;

    @Resource
    private UserGrantWechatAppMapper userGrantWechatAppMapper;

    @Resource
    private HuolaUserRegisterIntegrationService userRegisterIntegrationService;

    @Override
    public Boolean cancelUser(CancelUserParam cancelUserParam) {
        return null;
    }

    @Override
    public Long generateUserId(UserRegisterParam userRegisterParam) {
        return userRegisterIntegrationService.userRegister(userRegisterParam);
    }

    @Override
    public void updateStatus(Long userId, UserStateEnum status) {

    }

    @Override
    public Optional<Long> userUnionIdExist(String unionId) {
        //判断用户是否存在
        LambdaQueryWrapper<UserGrantWechatAppEntity> queryWrapper = new LambdaQueryWrapper<>();

        queryWrapper.eq(UserGrantWechatAppEntity::getUnionId, unionId);
        queryWrapper.eq(UserGrantWechatAppEntity::getDeleted, 0);

        List<UserGrantWechatAppEntity> userGrantWechatAppEntityList = userGrantWechatAppMapper.selectList(queryWrapper);

        if (!CollectionUtils.isEmpty(userGrantWechatAppEntityList)) {
            return Optional.ofNullable(userGrantWechatAppEntityList.get(0).getUserId());
        }
        return Optional.empty();
    }

    @Override
    public Optional<Long> userPhoneExist(String phone) {
        //判断用户是否存在
        LambdaQueryWrapper<UserInfoEntity> queryWrapper = new LambdaQueryWrapper<>();

        queryWrapper.eq(UserInfoEntity::getPhone, phone);

        List<UserInfoEntity> userWechatAppEntityList = userInfoMapper.selectList(queryWrapper);

        if (!CollectionUtils.isEmpty(userWechatAppEntityList)) {
            return Optional.of(userWechatAppEntityList.get(0).getId());
        }

        return Optional.empty();
    }

    @Override
    public Optional<Long> userUsernameExist(String username) {
        //判断用户是否存在
        LambdaQueryWrapper<UserInfoEntity> queryWrapper = new LambdaQueryWrapper<>();

        queryWrapper.eq(UserInfoEntity::getUsername, username);

        List<UserInfoEntity> userInfoEntityList = userInfoMapper.selectList(queryWrapper);

        if (!CollectionUtils.isEmpty(userInfoEntityList)) {
            return Optional.of(userInfoEntityList.get(0).getId());
        }

        return Optional.empty();
    }

    @Override
    public boolean checkUserPassword(Long userId, String username, String password) {
        UserInfoEntity userInfoEntity = userInfoMapper.selectById(userId);

        String targetPassword = MD5Util.encode(MD5Util.encode(password) + userInfoEntity.getSalt());
        String realPassword = userInfoEntity.getPassword();

        return Objects.equals(targetPassword, realPassword);
    }

    @Override
    public void updateUserPassword(Long userId, String password) {
        UserInfoEntity dbUserInfo = userInfoMapper.selectById(userId);

        String salt = dbUserInfo.getSalt();
        UserInfoEntity userInfoEntity = new UserInfoEntity();

        userInfoEntity.setId(userId);
        userInfoEntity.setPassword(MD5Util.encode(password, salt));

        userInfoMapper.updateById(userInfoEntity);
    }

    @Override
    public boolean hasSettingPassword(String username) {
        //判断用户是否存在
        LambdaQueryWrapper<UserInfoEntity> queryWrapper = new LambdaQueryWrapper<>();

        queryWrapper.eq(UserInfoEntity::getUsername, username);

        List<UserInfoEntity> userInfoEntityList = userInfoMapper.selectList(queryWrapper);

        if (!CollectionUtils.isEmpty(userInfoEntityList)) {
            return StringUtils.isNotBlank(userInfoEntityList.get(0).getPassword());
        }
        log.error("用户名不存在，用户名：{}", username);

        return false;
    }

    @Override
    public void bindPhone(Long userId, String phone) {

        UserInfoEntity userInfoEntity = new UserInfoEntity();

        userInfoEntity.setId(userId);
        userInfoEntity.setPhone(phone);

        userInfoMapper.updateById(userInfoEntity);
    }

    @Override
    public void bindUsername(Long userId, String username) {
        UserInfoEntity userInfoEntity = new UserInfoEntity();

        userInfoEntity.setId(userId);
        userInfoEntity.setUsername(username);

        userInfoMapper.updateById(userInfoEntity);
    }

    @Override
    public UserInfoEntity selectUserById(Long userId) {
        LambdaQueryWrapper<UserInfoEntity> queryWrapper = new LambdaQueryWrapper<>();

        queryWrapper.eq(UserInfoEntity::getId, userId);
        queryWrapper.eq(UserInfoEntity::getDeleted, 0);
        return userInfoMapper.selectOne(queryWrapper);
    }

    @Override
    public UserInfoEntity selectAllUserById(Long userId) {
        LambdaQueryWrapper<UserInfoEntity> queryWrapper = new LambdaQueryWrapper<>();

        queryWrapper.eq(UserInfoEntity::getId, userId);
        return userInfoMapper.selectOne(queryWrapper);
    }

    @Override
    public int updateUserInfo(UserInfoEntity userInfoEntity) {
        return userInfoMapper.updateById(userInfoEntity);
    }


}