/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.egg.user.invite.bind;

import com.bxm.egg.common.constant.InviteTypeEnum;
import com.bxm.egg.user.enums.AppConst;
import com.bxm.egg.user.enums.InviteBindMethodEnum;
import com.bxm.egg.user.invite.InviteRecordService;
import com.bxm.egg.user.mapper.UserInviteHistoryMapper;
import com.bxm.egg.user.model.dto.UserInviteBindDTO;
import com.bxm.newidea.component.bo.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * @author : jieli.xu
 * @date 2020/7/13 18:58
 * 激活码激活VIP时绑定的师徒关系
 */
@Component
@Slf4j
public class ActiveCodeBindMethod extends AbstractBindInviteStrategy {

    @Autowired
    private InviteRecordService inviteRecordService;
    @Autowired
    private UserInviteHistoryMapper userInviteHistoryMapper;

    @Override
    protected Message preInvoke(UserInviteBindDTO userInviteBindDTO) {
        //激活码激活时，已经存在邀请记录，但是关系未确定
        if (userInviteBindDTO.getAlreadyHas()) {
            //发生场景： A邀请 B, 然后B激活了，B 就更新成为A的徒弟。
            userInviteBindDTO.setNeedUpdate(true);
        } else {
            //发生场景：A邀请B，A有次数，但是B还没登录，就保存状态为B的用户状态
            if (userInviteBindDTO.getActiveCodeHasTime()) {
                //此处设置为用户的状态，可能state=2
                userInviteBindDTO.getUserInviteHistoryBean().setActiveVip(AppConst.ENABLE.byteValue());
                userInviteBindDTO.getUserInviteHistoryBean().setState(userInviteBindDTO.getUser().getState());
                userInviteBindDTO.getUserInviteHistoryBean().setRelationTitle(InviteTypeEnum.ACTIVE_CODE.getDesc());
                userInviteBindDTO.getUserInviteHistoryBean().setBindTime(new Date());
                return Message.build(true);
            } else {
                //发生场景：A邀请B，A没有次数，就只插入record记录，等待B登录后确定最终关系
                inviteRecordService.addInviteRecord(userInviteBindDTO.getInviteUserId(), userInviteBindDTO.getUserId(), this.getBindMethod().name());
            }
        }
        return Message.build(false);
    }

    @Override
    protected void beNormalInviteAfter(UserInviteBindDTO userInviteBindDTO) {
    }


    @Override
    protected InviteBindMethodEnum getBindMethod() {
        return InviteBindMethodEnum.ACTIVE_CODE;
    }
}
