package com.bxm.egg.user.invite.processor;

import com.bxm.egg.common.constant.InviteTypeEnum;
import com.bxm.egg.user.invite.InviteProcessorContext;
import com.bxm.egg.user.model.vo.UserInviteHistoryBean;
import com.bxm.newidea.component.bo.Message;
import org.springframework.stereotype.Component;

/**
 * 通过激活码建立邀请关系的逻辑处理
 *
 * @author liujia
 * @date 2020/05/12 14:03
 */
@Component
public class ActiveCodeInviteTypeProcessor extends AbstractInviteTypeProcessor {
    @Override
    public String obtainTitle(InviteProcessorContext context) {
        return "激活码";
    }

    @Override
    Message callback(InviteProcessorContext context) {
        return null;
    }

    @Override
    public InviteTypeEnum support() {
        return InviteTypeEnum.ACTIVE_CODE;
    }


    @Override
    public String decorateTitle(UserInviteHistoryBean inviteHistory) {
        return "的激活码邀请";
    }
}
