package com.bxm.egg.user.login.event;

import com.bxm.egg.user.constant.UserLoginTypeEnum;
import com.bxm.egg.user.model.param.login.LoginParam;
import lombok.Data;

/**
 * 用户登录事件
 *
 * @author wzy
 * @date 2021年09月16日13:15:18
 **/
@Data
public class LoginEvent<T extends LoginParam> {

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 用户是否首次登录
     */
    private boolean firstLogin;

    /**
     * 用户昵称
     */
    private String nickName;

    /**
     * 用户头像
     */
    private String headImg;

    /**
     * 登录方式
     */
    private UserLoginTypeEnum loginType;

    /**
     * 登录参数
     */
    private T loginParam;
}
