package com.bxm.egg.user.medal.strategy.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.user.account.UserAccountService;
import com.bxm.egg.user.enums.UserMedalCounterTypeEnum;
import com.bxm.egg.user.enums.UserMedalTypeEnum;
import com.bxm.egg.user.medal.strategy.AbstractMedalCounterStrategy;
import com.bxm.egg.user.model.dto.medal.MedalExtDataDTO;
import com.bxm.egg.user.model.dto.medal.UserMedalCounterDTO;
import com.bxm.egg.user.model.entity.UserAccountEntity;
import com.bxm.egg.user.model.entity.medal.UserMedalInfoEntity;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 鸡蛋数量统计策略类
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/23 9:38 上午
 */
@Slf4j
@Component
@AllArgsConstructor
public class EggCounterStrategy extends AbstractMedalCounterStrategy {

    private UserAccountService userAccountService;

    @Override
    protected void handleCounterData(UserMedalCounterDTO userMedalCounterDTO) {

        //1、查询账户获得鸡蛋总数数量
        UserAccountEntity userAccountInfo = userAccountService.getUserAccountInfo(userMedalCounterDTO.getUserId());

        Integer allEggNum = userAccountInfo.getAllEgg();

        //2、获取鸡蛋数量勋章的所有信息，判断是否达到条件
        handleEggMedal(userMedalCounterDTO.getUserId(), allEggNum, UserMedalTypeEnum.EGG_NEW_USER);
        handleEggMedal(userMedalCounterDTO.getUserId(), allEggNum, UserMedalTypeEnum.EGG_TALENT);
        handleEggMedal(userMedalCounterDTO.getUserId(), allEggNum, UserMedalTypeEnum.EGG_FARMER);
        handleEggMedal(userMedalCounterDTO.getUserId(), allEggNum, UserMedalTypeEnum.RICH_ONE_PLACE);
        handleEggMedal(userMedalCounterDTO.getUserId(), allEggNum, UserMedalTypeEnum.RICH_EQUAL_STATE);
    }

    @Override
    protected String counterType() {
        return UserMedalCounterTypeEnum.EGG_NUM.name();
    }

    private void handleEggMedal(Long userId, Integer allEggNum, UserMedalTypeEnum userMedalTypeEnum) {
        List<UserMedalInfoEntity> medalInfoEntityList = achievementMedalCacheManager.getMedalListByType(userMedalTypeEnum.name());

        for (UserMedalInfoEntity userMedalInfoEntity : medalInfoEntityList) {
            MedalExtDataDTO medalExtDataDTO = JSON.parseObject(userMedalInfoEntity.getRuleExtData(), MedalExtDataDTO.class);
            if (allEggNum >= medalExtDataDTO.getTargetValue()) {
                //4、如果达到了条件，如果没有获得过，则颁发勋章
                grantAchievementMedal(userId, userMedalInfoEntity);
            } else {
                //如果没有达到条件，则不再继续循环直接返回，因为后面等级勋章的条件会更高
                return;
            }
        }
    }
}