package com.bxm.egg.user.warmlevel.impl.handler;

import com.bxm.egg.user.enums.WarmRuleEnum;
import com.bxm.egg.user.warmlevel.impl.context.WarmActionContext;
import com.bxm.egg.user.warmlevel.impl.rule.WarmRule;
import com.bxm.newidea.component.bo.Message;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

/**
 * 默认的处理器，当请求设置错误的时候进行兼容，输出日志提示粗心的调用者
 *
 * @author lowi
 * @date 2021/03/03
 */
@Slf4j
public class DefaultWarmActionHandler implements WarmActionHandler {

    @Override
    public Message handle(WarmActionContext context) {
        log.warn("请求处理的WarmRuleEnum:{}未找到对应的ActionHandler，请实现一个对应的"
                        + "WarmActionHandler并注册到 SpringContext",
                context.getOriginParam().getWarmRuleEnum());
        return Message.build(false).setMessage("请求处理的WarmRuleEnum:{}未找到对应的ActionHandler，" +
                "请实现一个对应的WarmActionHandler并注册到 SpringContext");
    }

    @Override
    public WarmRuleEnum support() {
        return null;
    }

    @Override
    public Class<? extends WarmRule> bindRules() {
        return null;
    }
}
