package com.bxm.egg.user.warmlevel.impl.handler;

import com.bxm.egg.user.enums.WarmRuleEnum;
import com.bxm.egg.user.warmlevel.impl.context.WarmActionContext;
import com.bxm.egg.user.warmlevel.impl.rule.WarmRule;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 用户删除评论温暖值发放
 *
 * @author lowi
 * @date 2021/03/03 10:46
 */
@Component
public class UserDelCommentActionHandler extends AbstractWarmActionHandler {


    @Override
    protected void execAction(WarmActionContext context) {
        //获取此规则需要更改的温暖值
        context.setWarmRuleDetail(getWarmRule(context.getAction().name()));
    }

    @Override
    protected void afterPost(WarmActionContext context) {
    }

    @Override
    public WarmRuleEnum support() {
        return WarmRuleEnum.ONESELF_DEL_COMMENT;
    }

    @Override
    public Class<? extends WarmRule> bindRules() {
        return null;
    }
}
