package com.bxm.egg.user.warmlevel.impl.handler;

import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.enums.WarmRuleEnum;
import com.bxm.egg.user.warmlevel.impl.context.WarmActionContext;
import com.bxm.egg.user.warmlevel.impl.rule.LoginRule;
import com.bxm.egg.user.warmlevel.impl.rule.WarmRule;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * 用户登录温暖值发放
 *
 * @author lowi
 * @date 2021/03/03 10:46
 */
@Component
public class UserLoginActionHandler extends AbstractWarmActionHandler {

    @Autowired
    private RedisSetAdapter redisSetAdapter;

    @Override
    protected void execAction(WarmActionContext context) {
        //获取此规则需要更改的温暖值
        context.setWarmRuleDetail(getWarmRule(context.getAction().name()));
    }

    @Override
    protected void afterPost(WarmActionContext context) {
        KeyGenerator key = RedisConfig.USER_LOGIN_WARM.copy().appendKey(DateUtils.formatDate(new Date()));
        redisSetAdapter.add(key, context.getUserId());
        redisSetAdapter.expire(key, 2 * 24 * 60 * 60);
    }

    @Override
    public WarmRuleEnum support() {
        return WarmRuleEnum.LOGIN;
    }

    @Override
    public Class<? extends WarmRule> bindRules() {
        return LoginRule.class;
    }
}
