package com.bxm.egg.user.warmlevel.impl.rule;

import com.alibaba.fastjson.JSONObject;
import com.bxm.egg.user.enums.WarmRuleEnum;
import com.bxm.egg.user.model.vo.warmlevel.WarmRuleDetail;
import com.bxm.egg.user.warmlevel.UserWarmLevelService;
import com.bxm.egg.user.warmlevel.impl.context.WarmActionContext;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.bo.Message;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * @author lowi
 * @date 2021/3/3 16:28
 */
@Component
public class ContinuitySignRule implements WarmRule {

    protected UserWarmLevelService userWarmLevelService;

    @Override
    public Message apply(WarmActionContext context) {
        if (Objects.isNull(context.getOriginParam().getExtData())) {
            return Message.build(false).setMessage("扩展字段数据不对");
        }
        if (null == userWarmLevelService) {
            userWarmLevelService = SpringContextHolder.getBean(UserWarmLevelService.class);
        }
        WarmRuleDetail warmRule = userWarmLevelService.getWarmRule(WarmRuleEnum.CONTINUITY_SIGN.name());
        String extData = warmRule.getExtData();
        if (StringUtils.isBlank(extData)) {
            return Message.build(false).setMessage("连续签到未设置增加温暖值");
        }
        JSONObject jsonObject = JSONObject.parseObject(extData);
        String key = (String) context.getOriginParam().getExtData();
        if (Objects.isNull(jsonObject.get(key))) {
            return Message.build(false).setMessage("连续签到数据未触发加温暖值");
        }
        context.getOriginParam().setWarmValue((Integer) jsonObject.get(key));
        return Message.build(true);
    }

    @Override
    public boolean retryOnFailed() {
        return false;
    }
}
