package com.bxm.egg.user.auth.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.bxm.egg.user.auth.UserBlockExpiredTaskService;
import com.bxm.egg.user.mapper.UserBlockExpiredTaskMapper;
import com.bxm.egg.user.model.entity.UserBlockExpiredTaskEntity;
import com.bxm.newidea.component.uuid.SequenceCreater;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/17 5:25 下午
 */
@Slf4j
@Service
public class UserBlockExpiredTaskServiceImpl implements UserBlockExpiredTaskService {

    @Resource
    private UserBlockExpiredTaskMapper userBlockExpiredTaskMapper;

    @Resource
    private SequenceCreater sequenceCreater;

    @Override
    public void addTask(Long userId, List<Integer> index, Date expiredTime) {
        UserBlockExpiredTaskEntity newTask = new UserBlockExpiredTaskEntity();
        newTask.setId(sequenceCreater.nextLongId());
        newTask.setExpiredTime(expiredTime);
        newTask.setUserId(userId);
        newTask.setAuthIndex(JSON.toJSONString(index));

        userBlockExpiredTaskMapper.insert(newTask);
    }

    @Override
    public void removeTask(Long userId) {
        LambdaUpdateWrapper<UserBlockExpiredTaskEntity> updateWrapper = new LambdaUpdateWrapper<>();

        updateWrapper.eq(UserBlockExpiredTaskEntity::getUserId, userId);
        userBlockExpiredTaskMapper.delete(updateWrapper);
    }

    @Override
    public List<UserBlockExpiredTaskEntity> getExpiredTaskList() {

        LambdaQueryWrapper<UserBlockExpiredTaskEntity> queryWrapper = new LambdaQueryWrapper<>();

        queryWrapper.le(UserBlockExpiredTaskEntity::getExpiredTime, new Date());

        return userBlockExpiredTaskMapper.selectList(queryWrapper);
    }
}