package com.bxm.egg.user.facade;

import com.bxm.egg.user.facade.service.UserFollowFacadeService;
import com.bxm.egg.user.follow.UserFollowService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboService;

import javax.annotation.Resource;

/**
 * 用户关注关系Facade接口实现
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/28 2:58 下午
 */
@DubboService(protocol = {"dubbo"}, version = "1.0.0")
@Slf4j
public class UserFollowFacadeServiceImpl implements UserFollowFacadeService {

    @Resource
    private UserFollowService userFollowService;

    @Override
    public Boolean isFollow(Long userId, Long targetUserId) {
        return userFollowService.isFollowed(userId, targetUserId);
    }

    @Override
    public Boolean hasFollowMsg(Long userId, Long targetUid) {
        return userFollowService.hasFollowMsg(userId, targetUid);
    }

    @Override
    public void addHuolaFriends(Long userId, Long funsId, Byte type) {
        userFollowService.addHuolaFriends(userId, funsId, type);
    }
}